#!/usr/bin/python3

import pyrob.core as rob
from . import check_filled_cells

class Task:
    CHECKS = 1

    def load_level(self, n):
        rob.set_field_size(2, 9)
        rob.set_parking_cell(1, 8)
        

        rob.set_cell_type(0, 1, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(0, 3, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(0, 5, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(0, 7, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(1, 0, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(1, 2, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(1, 4, rob.CELL_TO_BE_FILLED)
        rob.set_cell_type(1, 6, rob.CELL_TO_BE_FILLED)

        
        rob.goto(1, 0)

    def check_solution(self):
        if not rob.is_parking_point():
            return False

        return check_filled_cells([(0, 1), (0, 3), (0, 5), (0, 7),
                                   (1, 0), (1, 2), (1, 4), (1, 6)])
