#!/usr/bin/python3

import pyrob.core as rob
from . import check_filled_cells, find_cells_to_be_filled
import random

class Task:
    CHECKS = 5

    def load_level(self, n):
        dl = random.randint(5, 20)
        rob.set_field_size(3, dl)
        k = random.randint(0, dl - 1)
        rob.set_parking_cell(1, k)
        rob.set_cell_type(1, k, rob.CELL_TO_BE_FILLED)
        self.cells_to_fill = find_cells_to_be_filled()
        for i in range(k):
            rob.goto(0, i)
            rob.put_wall(bottom = True)
        rob.goto(1, k)
        rob.put_wall(bottom = True, left = True, right = True)
        for i in range(k + 1, dl):
            rob.goto(0, i)
            rob.put_wall(bottom = True)
        rob.goto(0, 0)

    def check_solution(self):
        if not rob.is_parking_point():
            return False
        return check_filled_cells(self.cells_to_fill)
